import { type BaseEvalOptions } from './types';
export declare const knowledgeRetentionPrompt = "You are evaluating whether an LLM response correctly retains and applies facts or decisions provided earlier in the conversation.\n\n## Inputs\n\n- USER REQUEST (may include conversation history or prior context): {{USER_REQUEST}}\n- MODEL RESPONSE: {{MODEL_RESPONSE}}\n\n## Your task\n\n1. Assume an auditor checking for context consistency and memory accuracy.\n2. Identify all facts, decisions, preferences, or constraints established in the USER REQUEST or prior context, including:\n   - Names, dates, numbers, or specific values mentioned\n   - User preferences or requirements stated earlier\n   - Decisions or conclusions reached in prior exchanges\n   - Constraints or boundaries defined for the task\n   - Corrections or clarifications the user provided\n3. Check the MODEL RESPONSE for any of the following retention failures:\n   - Contradicting previously established facts\n   - Ignoring stated preferences or requirements\n   - Using incorrect values for previously defined variables\n   - Forgetting constraints that should limit the response\n   - Asking for information already provided\n   - Reverting to defaults when specific choices were made\n\n## Score\n\n- Start from 1.0.\n- Subtract points for each retention failure:\n   - Minor detail forgotten (peripheral to main task): \u22120.2\n   - Preference or requirement ignored: \u22120.4\n   - Key fact contradicted or misremembered: \u22120.5\n   - Critical constraint violated: \u22120.6\n- Minimum score is 0.0.\n- Multiple failures compound independently.\n\n## Pass/Fail\n\n- passed = true only if score \u2265 0.7 AND no critical facts are contradicted or key constraints violated.\n\n## Constraints\n\n- Do not assume the response \"probably meant\" the correct information.\n- Do not excuse retention failures because the response is otherwise helpful.\n- Do not credit partial retention if critical elements are missed.\n- If no prior context is provided, this eval automatically passes with score 1.0.\n- Evaluate only retention of information explicitly stated, not implied.\n\n## Output format (STRICT JSON, one line reason):\n\n{\n  \"score\": <number between 0.0 and 1.0>,\n  \"passed\": <true|false>,\n  \"reason\": \"<single concise sentence listing retention failures found or confirming context was correctly maintained>\"\n}";
type KnowledgeRetentionEvalOptions = BaseEvalOptions & {
    threshold: number;
};
export declare const knowledgeRetention: <TAgentInput extends import("@agentuity/core").StandardSchemaV1 | undefined = any, TAgentOutput extends import("@agentuity/core").StandardSchemaV1 | undefined = any>(overrides?: (Partial<{
    name?: string;
    description?: string;
} & BaseEvalOptions & {
    threshold: number;
}> & {
    middleware?: import("./types").EvalMiddleware<TAgentInput extends import("@agentuity/core").StandardSchemaV1<unknown, unknown> ? import("@agentuity/core").InferOutput<TAgentInput> : any, TAgentOutput extends import("@agentuity/core").StandardSchemaV1<unknown, unknown> ? import("@agentuity/core").InferOutput<TAgentOutput> : any, {
        request: string;
    } & {
        context?: string | undefined;
    }, {
        response: string;
    } & {}> | undefined;
}) | undefined) => import("@agentuity/runtime").CreateEvalConfig<any, any> & {
    name: string;
    options: KnowledgeRetentionEvalOptions;
};
export {};
//# sourceMappingURL=knowledge-retention.d.ts.map