import type { Command } from 'commander';
import type { CommandDefinition } from './types';
export interface SchemaArgument {
    name: string;
    type: string;
    required: boolean;
    variadic: boolean;
    description?: string;
}
export interface SchemaOption {
    name: string;
    type: 'string' | 'number' | 'boolean' | 'array';
    required: boolean;
    default?: unknown;
    description?: string;
    enum?: string[];
}
export interface SchemaPagination {
    supported: boolean;
    defaultLimit?: number;
    maxLimit?: number;
    parameters?: {
        limit?: string;
        offset?: string;
        cursor?: string;
    };
}
export interface SchemaExample {
    command: string;
    description: string;
}
export interface SchemaCommand {
    name: string;
    description: string;
    aliases?: string[];
    arguments?: SchemaArgument[];
    options?: SchemaOption[];
    examples?: SchemaExample[];
    response?: unknown;
    idempotent?: boolean;
    prerequisites?: string[];
    pagination?: SchemaPagination;
    tags?: string[];
    skipSkill?: boolean;
    toplevel?: boolean;
    subcommands?: SchemaCommand[];
    requires?: {
        auth?: boolean;
        project?: boolean;
        org?: boolean;
        region?: boolean;
        regions?: boolean;
    };
    optional?: {
        auth?: boolean | string;
        project?: boolean;
        org?: boolean;
        region?: boolean;
    };
}
export interface CLISchema {
    name: string;
    version: string;
    description: string;
    exitCodes: Record<number, string>;
    globalOptions: SchemaOption[];
    commands: SchemaCommand[];
}
/**
 * Generate JSON schema for the entire CLI
 */
export declare function generateCLISchema(program: Command, commands: CommandDefinition[], version: string): CLISchema;
//# sourceMappingURL=schema-generator.d.ts.map