import type { Logger, FileToWrite } from '@agentuity/core';
import { APIClient } from '@agentuity/server';
import type { AuthData } from '../../../types';
export declare function createSandboxClient(logger: Logger, auth: AuthData, region: string): APIClient;
/**
 * Parse --file arguments and read file contents.
 *
 * Formats:
 * - <sandbox-path>:<local-path>  - explicit mapping (e.g., script.js:./local/script.js)
 * - <filename>                   - shorthand, uses same name for both (e.g., script.js -> script.js:./script.js)
 *
 * @returns Array of FileToWrite objects
 */
export declare function parseFileArgs(fileArgs: string[] | undefined): FileToWrite[];
//# sourceMappingURL=util.d.ts.map