import type { EventEmitter } from 'node:events';
interface WritableWithDrain extends EventEmitter {
    write(chunk: Uint8Array): boolean;
}
/**
 * Error thrown when a sandbox API request fails.
 *
 * Includes optional context about which sandbox or execution caused the error.
 */
export declare const SandboxResponseError: {
    new (args?: ({
        /** The sandbox ID associated with the error, if applicable */
        sandboxId?: string;
        /** The execution ID associated with the error, if applicable */
        executionId?: string;
    } & {
        message?: string;
        cause?: unknown;
    }) | undefined): import("@agentuity/core").RichError & {
        readonly _tag: "SandboxResponseError";
    } & Readonly<{
        /** The sandbox ID associated with the error, if applicable */
        sandboxId?: string;
        /** The execution ID associated with the error, if applicable */
        executionId?: string;
    }>;
    readonly defaultMessage?: string;
};
/** Current sandbox API version */
export declare const API_VERSION = "2025-03-17";
/**
 * Write a chunk to a writable stream and wait for it to drain if necessary.
 * Properly cleans up event listeners to avoid memory leaks.
 */
export declare function writeAndDrain(writable: WritableWithDrain, chunk: Uint8Array): Promise<void>;
export {};
//# sourceMappingURL=util.d.ts.map