import { APIClient } from '../api';
export interface SnapshotFileInfo {
    path: string;
    size: number;
}
export interface SnapshotInfo {
    snapshotId: string;
    tag?: string | null;
    sizeBytes: number;
    fileCount: number;
    parentSnapshotId?: string | null;
    createdAt: string;
    downloadUrl?: string;
    files?: SnapshotFileInfo[];
}
export interface SnapshotCreateParams {
    sandboxId: string;
    tag?: string;
    orgId?: string;
}
export interface SnapshotGetParams {
    snapshotId: string;
    orgId?: string;
}
export interface SnapshotListParams {
    sandboxId?: string;
    limit?: number;
    offset?: number;
    orgId?: string;
}
export interface SnapshotListResponse {
    snapshots: SnapshotInfo[];
    total: number;
}
export interface SnapshotDeleteParams {
    snapshotId: string;
    orgId?: string;
}
export interface SnapshotTagParams {
    snapshotId: string;
    tag: string | null;
    orgId?: string;
}
/**
 * Creates a snapshot of a sandbox's current state.
 *
 * @param client - The API client to use for the request
 * @param params - Parameters including sandbox ID and optional tag
 * @returns The created snapshot information
 * @throws {SandboxResponseError} If the snapshot creation fails
 */
export declare function snapshotCreate(client: APIClient, params: SnapshotCreateParams): Promise<SnapshotInfo>;
/**
 * Retrieves detailed information about a specific snapshot.
 *
 * @param client - The API client to use for the request
 * @param params - Parameters including the snapshot ID
 * @returns Snapshot information including files and download URL
 * @throws {SandboxResponseError} If the snapshot is not found or request fails
 */
export declare function snapshotGet(client: APIClient, params: SnapshotGetParams): Promise<SnapshotInfo>;
/**
 * Lists snapshots with optional filtering and pagination.
 *
 * @param client - The API client to use for the request
 * @param params - Optional parameters for filtering by sandbox and pagination
 * @returns Paginated list of snapshots with total count
 * @throws {SandboxResponseError} If the request fails
 */
export declare function snapshotList(client: APIClient, params?: SnapshotListParams): Promise<SnapshotListResponse>;
/**
 * Deletes a snapshot and releases its storage.
 *
 * @param client - The API client to use for the request
 * @param params - Parameters including the snapshot ID to delete
 * @throws {SandboxResponseError} If the snapshot is not found or deletion fails
 */
export declare function snapshotDelete(client: APIClient, params: SnapshotDeleteParams): Promise<void>;
/**
 * Updates or removes the tag on a snapshot.
 *
 * @param client - The API client to use for the request
 * @param params - Parameters including snapshot ID and new tag (or null to remove)
 * @returns Updated snapshot information
 * @throws {SandboxResponseError} If the snapshot is not found or update fails
 */
export declare function snapshotTag(client: APIClient, params: SnapshotTagParams): Promise<SnapshotInfo>;
//# sourceMappingURL=snapshot.d.ts.map