import { APIClient } from '../api';
import type { ListSandboxesParams, ListSandboxesResponse } from '@agentuity/core';
export interface SandboxListParams extends ListSandboxesParams {
    orgId?: string;
}
/**
 * Lists sandboxes with optional filtering and pagination.
 *
 * @param client - The API client to use for the request
 * @param params - Optional parameters for filtering by project, status, and pagination
 * @returns Paginated list of sandboxes with total count
 * @throws {SandboxResponseError} If the request fails
 */
export declare function sandboxList(client: APIClient, params?: SandboxListParams): Promise<ListSandboxesResponse>;
//# sourceMappingURL=list.d.ts.map