import { APIClient } from '../api';
import type { SandboxInfo } from '@agentuity/core';
export interface SandboxGetParams {
    sandboxId: string;
    orgId?: string;
}
/**
 * Retrieves information about a specific sandbox.
 *
 * @param client - The API client to use for the request
 * @param params - Parameters including the sandbox ID
 * @returns Sandbox information including status, creation time, and execution count
 * @throws {SandboxResponseError} If the sandbox is not found or request fails
 */
export declare function sandboxGet(client: APIClient, params: SandboxGetParams): Promise<SandboxInfo>;
//# sourceMappingURL=get.d.ts.map