import { APIClient } from '../api';
import type { ExecutionStatus } from '@agentuity/core';
export interface ExecutionInfo {
    executionId: string;
    sandboxId: string;
    status: ExecutionStatus;
    command?: string[];
    exitCode?: number;
    durationMs?: number;
    startedAt?: string;
    completedAt?: string;
    error?: string;
    stdoutStreamUrl?: string;
    stderrStreamUrl?: string;
}
export interface ExecutionGetParams {
    executionId: string;
    orgId?: string;
}
/**
 * Retrieves detailed information about a specific execution.
 *
 * @param client - The API client to use for the request
 * @param params - Parameters including the execution ID
 * @returns Detailed execution information including status, timing, and errors
 * @throws {SandboxResponseError} If the execution is not found or request fails
 */
export declare function executionGet(client: APIClient, params: ExecutionGetParams): Promise<ExecutionInfo>;
export interface ExecutionListParams {
    sandboxId: string;
    orgId?: string;
    limit?: number;
}
export interface ExecutionListResponse {
    executions: ExecutionInfo[];
}
/**
 * Lists all executions for a specific sandbox.
 *
 * @param client - The API client to use for the request
 * @param params - Parameters including the sandbox ID and optional limit
 * @returns List of execution information for the sandbox
 * @throws {SandboxResponseError} If the sandbox is not found or request fails
 */
export declare function executionList(client: APIClient, params: ExecutionListParams): Promise<ExecutionListResponse>;
//# sourceMappingURL=execution.d.ts.map