import { z } from 'zod';
import { APIClient } from '../api';
declare const CreateResourcesRequest: z.ZodObject<{
    resources: z.ZodArray<z.ZodObject<{
        type: z.ZodEnum<{
            s3: "s3";
            db: "db";
        }>;
        name: z.ZodOptional<z.ZodString>;
    }, z.core.$strip>>;
}, z.core.$strip>;
declare const CreatedResource: z.ZodObject<{
    type: z.ZodString;
    name: z.ZodString;
    env: z.ZodRecord<z.ZodString, z.ZodString>;
}, z.core.$strip>;
declare const CreateResourcesResponseSchema: z.ZodDiscriminatedUnion<[z.ZodObject<{
    success: z.ZodLiteral<false>;
    message: z.ZodString;
}, z.core.$strip>, z.ZodObject<{
    success: z.ZodLiteral<true>;
    data: z.ZodObject<{
        created: z.ZodArray<z.ZodObject<{
            type: z.ZodString;
            name: z.ZodString;
            env: z.ZodRecord<z.ZodString, z.ZodString>;
        }, z.core.$strip>>;
    }, z.core.$strip>;
}, z.core.$strip>], "success">;
export type CreateResourcesRequest = z.infer<typeof CreateResourcesRequest>;
export type CreateResourcesResponse = z.infer<typeof CreateResourcesResponseSchema>;
export type CreatedResource = z.infer<typeof CreatedResource>;
/**
 * Create one or more resources (DB or S3) for an organization in a specific region
 * Requires CLI authentication
 *
 * @param client - Catalyst API client
 * @param orgId - Organization ID
 * @param region - Cloud region
 * @param resources - Array of resources to create
 * @returns
 */
export declare function createResources(client: APIClient, orgId: string, region: string, resources: Array<{
    type: 'db' | 's3';
    name?: string;
}>): Promise<CreatedResource[]>;
export {};
//# sourceMappingURL=create.d.ts.map