import { z } from 'zod';
import { APIClient } from '../api';
declare const OrgS3Resource: z.ZodObject<{
    bucket_name: z.ZodString;
    access_key: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    secret_key: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    region: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    endpoint: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    cloud_region: z.ZodString;
}, z.core.$strip>;
declare const OrgDBResource: z.ZodObject<{
    name: z.ZodString;
    username: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    password: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    url: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    cloud_region: z.ZodString;
}, z.core.$strip>;
declare const OrgResourceListResponse: z.ZodObject<{
    s3: z.ZodArray<z.ZodObject<{
        bucket_name: z.ZodString;
        access_key: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        secret_key: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        region: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        endpoint: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        cloud_region: z.ZodString;
    }, z.core.$strip>>;
    db: z.ZodArray<z.ZodObject<{
        name: z.ZodString;
        username: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        password: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        url: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        cloud_region: z.ZodString;
    }, z.core.$strip>>;
}, z.core.$strip>;
declare const OrgResourceListResponseSchema: z.ZodDiscriminatedUnion<[z.ZodObject<{
    success: z.ZodLiteral<false>;
    message: z.ZodString;
}, z.core.$strip>, z.ZodObject<{
    success: z.ZodLiteral<true>;
    data: z.ZodObject<{
        s3: z.ZodArray<z.ZodObject<{
            bucket_name: z.ZodString;
            access_key: z.ZodOptional<z.ZodNullable<z.ZodString>>;
            secret_key: z.ZodOptional<z.ZodNullable<z.ZodString>>;
            region: z.ZodOptional<z.ZodNullable<z.ZodString>>;
            endpoint: z.ZodOptional<z.ZodNullable<z.ZodString>>;
            cloud_region: z.ZodString;
        }, z.core.$strip>>;
        db: z.ZodArray<z.ZodObject<{
            name: z.ZodString;
            username: z.ZodOptional<z.ZodNullable<z.ZodString>>;
            password: z.ZodOptional<z.ZodNullable<z.ZodString>>;
            url: z.ZodOptional<z.ZodNullable<z.ZodString>>;
            cloud_region: z.ZodString;
        }, z.core.$strip>>;
    }, z.core.$strip>;
}, z.core.$strip>], "success">;
export type OrgResourceListResponse = z.infer<typeof OrgResourceListResponseSchema>;
export type OrgResourceList = z.infer<typeof OrgResourceListResponse>;
export type OrgS3Resource = z.infer<typeof OrgS3Resource>;
export type OrgDBResource = z.infer<typeof OrgDBResource>;
export interface ListOrgResourcesOptions {
    /** Filter by resource type (default: "all") */
    type?: 'all' | 's3' | 'db';
}
/**
 * List all resources for the authenticated organization (across all regions)
 * Extracts orgId from authentication context (API key, SDK, or CLI token)
 *
 * @param client - Catalyst API client (must be authenticated)
 * @param options - Optional filters
 * @returns List of S3 and DB resources with their cloud regions
 *
 * @example
 * // Get all resources
 * const all = await listOrgResources(client);
 *
 * @example
 * // Get only S3 buckets
 * const s3Only = await listOrgResources(client, { type: 's3' });
 *
 * @example
 * // Get only DBs
 * const dbsOnly = await listOrgResources(client, { type: 'db' });
 */
export declare function listOrgResources(client: APIClient, options?: ListOrgResourcesOptions): Promise<OrgResourceList>;
export {};
//# sourceMappingURL=resources.d.ts.map