import type { Database } from 'bun:sqlite';
import type { VectorStorage, VectorUpsertParams, VectorUpsertResult, VectorResult, VectorSearchResultWithDocument, VectorSearchParams, VectorSearchResult, VectorNamespaceStats, VectorNamespaceStatsWithSamples } from '@agentuity/core';
export declare class LocalVectorStorage implements VectorStorage {
    #private;
    constructor(db: Database, projectPath: string);
    upsert(name: string, ...documents: VectorUpsertParams[]): Promise<VectorUpsertResult[]>;
    get<T extends Record<string, unknown> = Record<string, unknown>>(name: string, key: string): Promise<VectorResult<T>>;
    getMany<T extends Record<string, unknown> = Record<string, unknown>>(name: string, ...keys: string[]): Promise<Map<string, VectorSearchResultWithDocument<T>>>;
    search<T extends Record<string, unknown> = Record<string, unknown>>(name: string, params: VectorSearchParams<T>): Promise<VectorSearchResult<T>[]>;
    delete(name: string, ...keys: string[]): Promise<number>;
    exists(name: string): Promise<boolean>;
    getStats(name: string): Promise<VectorNamespaceStatsWithSamples>;
    getAllStats(): Promise<Record<string, VectorNamespaceStats>>;
    getNamespaces(): Promise<string[]>;
    deleteNamespace(name: string): Promise<void>;
}
//# sourceMappingURL=vector.d.ts.map