export declare function init(): void;
/**
 * Returns the SDK Version that was used to build this app
 *
 * @returns string
 */
export declare function getSDKVersion(): string;
/**
 * Returns the App Name that was used when this app was built
 *
 * @returns string
 */
export declare function getAppName(): string;
/**
 * Returns the App Version that was used when this app was built
 *
 * @returns string
 */
export declare function getAppVersion(): string;
/**
 * Returns the Organization ID for this app
 *
 * @returns string
 */
export declare function getOrganizationId(): string | undefined;
/**
 * Returns the Project ID for this app
 *
 * @returns string
 */
export declare function getProjectId(): string | undefined;
/**
 * Returns the Deployment ID for this app that was deployed
 *
 * @returns string | undefined
 */
export declare function getDeploymentId(): string | undefined;
/**
 * Returns true if the app is running in dev mode
 *
 * @returns boolean
 */
export declare function isDevMode(): boolean;
/**
 * Returns true if the app is running in production mode
 *
 * @returns boolean
 */
export declare function isProduction(): boolean;
/**
 * Returns the CLI version that was used when this app was built
 *
 * @returns string
 */
export declare function getCLIVersion(): string;
/**
 * Returns the environment setting for this app
 *
 * @returns string
 */
export declare function getEnvironment(): string;
/**
 * Returns true if the AGENTUITY_SDK_KEY is set
 *
 * @returns boolean
 */
export declare function isAuthenticated(): boolean;
/**
 * Symbol for accessing internal runtime state.
 * Defined here to avoid circular dependency.
 */
export declare const AGENT_RUNTIME: unique symbol;
/**
 * Symbol for accessing internal agent from AgentRunner.
 * @internal
 */
export declare const INTERNAL_AGENT: unique symbol;
/**
 * Symbol for tracking the current executing agent (for telemetry).
 * Not exposed on public AgentContext interface.
 * @internal
 */
export declare const CURRENT_AGENT: unique symbol;
/**
 * Symbol for tracking agent IDs that have executed in this session.
 * Used in standalone contexts to track agents for session events.
 * @internal
 */
export declare const AGENT_IDS: unique symbol;
//# sourceMappingURL=_config.d.ts.map