import { type BaseEvalOptions } from './types';
export declare const extraneousContentPrompt = "You are evaluating whether an LLM response contains content clearly unrelated or unnecessary for fulfilling the request.\n\n## Inputs\n\n- USER REQUEST: {{USER_REQUEST}}\n- MODEL RESPONSE: {{MODEL_RESPONSE}}\n\n## Your task\n\n1. Assume a strict editor who removes anything not directly serving the user's goal.\n2. Identify each distinct section, paragraph, or statement in the MODEL RESPONSE.\n3. For each element, determine whether it contributes to answering the USER REQUEST.\n4. Flag any of the following as extraneous content:\n   - Topics or information not requested and not necessary for context\n   - Unsolicited advice or recommendations beyond the scope of the request\n   - Self-promotional statements about capabilities\n   - Unnecessary caveats or warnings unrelated to the specific request\n   - Meta-commentary about the response itself (e.g., \"I hope this helps!\")\n   - Offers to help with additional unrelated tasks\n   - Background information the user clearly already knows based on their request\n   - Repeated information already stated elsewhere in the response\n\n## Score\n\n- Start from 1.0.\n- Subtract points for each extraneous element:\n   - Brief unnecessary phrase or sentence: \u22120.2\n   - Full paragraph of off-topic content: \u22120.4\n   - Multiple paragraphs or significant tangent: \u22120.6\n- Minimum score is 0.0.\n- Multiple violations compound independently.\n\n## Pass/Fail\n\n- passed = true only if score \u2265 {{THRESHOLD}} AND no major tangents or significant off-topic content is present.\n\n## Constraints\n\n- Do not credit relevant information for excusing unrelated additions.\n- Do not assume the user wants additional context unless requested.\n- Do not excuse extraneous content because it might be \"useful\" to some readers.\n- Helpful-but-unsolicited content is still extraneous if not requested.\n- Necessary context to understand the answer is not extraneous.\n\n## Output format (STRICT JSON, one line reason):\n\n{\n  \"score\": <number between 0.0 and 1.0>,\n  \"passed\": <true|false>,\n  \"reason\": \"<single concise sentence listing extraneous content found or confirming all content was relevant>\"\n}";
type ExtraneousContentEvalOptions = BaseEvalOptions & {
    threshold: number;
};
export declare const extraneousContent: <TAgentInput extends import("@agentuity/core").StandardSchemaV1 | undefined = any, TAgentOutput extends import("@agentuity/core").StandardSchemaV1 | undefined = any>(overrides?: (Partial<{
    name?: string;
    description?: string;
} & BaseEvalOptions & {
    threshold: number;
}> & {
    middleware?: import("./types").EvalMiddleware<TAgentInput extends import("@agentuity/core").StandardSchemaV1<unknown, unknown> ? import("@agentuity/core").InferOutput<TAgentInput> : any, TAgentOutput extends import("@agentuity/core").StandardSchemaV1<unknown, unknown> ? import("@agentuity/core").InferOutput<TAgentOutput> : any, {
        request: string;
    } & {
        context?: string | undefined;
    }, {
        response: string;
    } & {}> | undefined;
}) | undefined) => import("@agentuity/runtime").CreateEvalConfig<any, any> & {
    name: string;
    options: ExtraneousContentEvalOptions;
};
export {};
//# sourceMappingURL=extraneous-content.d.ts.map