export function generateEnvWarning(envkey) {
    return `if (process.env.AGENTUITY_ENVIRONMENT === 'development' || process.env.NODE_ENV !== 'production') {
      console.error('The required environment variable ${envkey} must be set in your project .env file or in your local system environment.');
     } else {
      console.error('The required environment variable ${envkey} is required for this project. Use "agentuity env set ${envkey}" to set it and redeploy your project.');
     }
`;
}
export function generateJSArgsPatch(index, inject) {
    return `const _newargs = [...(_args ?? [])];
_newargs[${index}] = {..._newargs[${index}], ${inject}};
_args = _newargs;`;
}
export function generateEnvGuard(name, inject, alt) {
    return `if (!process.env.${name} || process.env.${name}  ===  process.env.AGENTUITY_SDK_KEY) {
${inject}
} else {
	${alt ?? ''}}`;
}
export function generateGatewayEnvGuard(apikey, apikeyval, apibase, provider) {
    return `{
    const _agentuity_sdk_key = process.env.AGENTUITY_SDK_KEY;
    const _agentuity_url = process.env.AGENTUITY_AIGATEWAY_URL || process.env.AGENTUITY_TRANSPORT_URL || (_agentuity_sdk_key ? 'https://agentuity.ai' : '');
    if (_agentuity_url && _agentuity_sdk_key) {
        process.env.${apikey} = _agentuity_sdk_key;
        process.env.${apibase} = _agentuity_url + '/gateway/${provider}';
        console.debug('Enabled Agentuity AI Gateway for ${provider}');
    } else if (!process.env.${apikey}) {
     ${generateEnvWarning(apikey)}
    }
}
`;
}
export function searchBackwards(contents, offset, val) {
    for (let i = offset; i >= 0; i--) {
        if (contents.charAt(i) == val) {
            return i;
        }
    }
    return -1;
}
//# sourceMappingURL=_util.js.map