import { jsx as _jsx, jsxs as _jsxs, Fragment as _Fragment } from "react/jsx-runtime";
import { Braces, X } from 'lucide-react';
import { CodeBlock, CodeBlockCopyButton } from '../ai-elements/code-block';
import { Button } from '../ui/button';
import { ScrollArea } from '../ui/scroll-area';
import { useWorkbench } from './workbench-provider';
export function Schema({ onOpenChange }) {
    const { agents, selectedAgent, schemasLoading, schemasError } = useWorkbench();
    const selectedAgentData = Object.values(agents).find((agent) => agent.metadata.agentId === selectedAgent) || null;
    return (_jsxs("div", { className: "h-full flex flex-col", children: [onOpenChange && (_jsxs("div", { className: "flex items-center justify-between py-2.5 px-4.5 border-b border-border", children: [_jsxs("div", { className: "flex items-center gap-2", children: [_jsx(Braces, { className: "size-5 text-muted-foreground" }), _jsx("h2", { className: "font-medium mt-0.5", children: "Schema" })] }), _jsx(Button, { variant: "ghost", size: "icon", onClick: () => onOpenChange(false), className: "size-8", children: _jsx(X, { className: "size-4" }) })] })), _jsx(ScrollArea, { className: "flex-1 text-sm overflow-hidden", children: _jsxs("div", { className: "flex flex-col gap-6 p-4", children: [schemasLoading && (_jsx("div", { className: "text-center text-muted-foreground/70 py-8", "data-loading": true, children: "Loading schema" })), schemasError && (_jsxs("div", { className: "flex flex-col gap-1 rounded-md bg-destructive/10 text-destructive py-2.5 px-4", children: [_jsx("p", { className: "font-medium", children: "Error Loading Schemas" }), _jsx("p", { className: "text-xs", children: schemasError.message })] })), !schemasLoading && !schemasError && !selectedAgentData && (_jsx("div", { className: "text-center text-muted-foreground/70 py-8", children: _jsx("p", { children: "No schema available for selected agent" }) })), !schemasLoading && !schemasError && selectedAgentData && (_jsxs(_Fragment, { children: [selectedAgentData.schema.input?.code ? (_jsxs("div", { className: "flex flex-col gap-2", children: [_jsx("h3", { className: "text-sm text-muted-foreground", children: "Input Schema" }), _jsx(CodeBlock, { code: selectedAgentData.schema.input?.code, language: "typescript", className: "text-xs! [&_code]:text-xs! [&_pre]:py-3!", children: _jsx(CodeBlockCopyButton, {}) })] })) : null, selectedAgentData.schema.output?.code ? (_jsxs("div", { className: "flex flex-col gap-2", children: [_jsx("h3", { className: "text-sm text-muted-foreground", children: "Output Schema" }), _jsx(CodeBlock, { code: selectedAgentData.schema.output?.code, language: "typescript", className: "text-xs! [&_code]:text-xs! [&_pre]:py-3!", children: _jsx(CodeBlockCopyButton, {}) })] })) : null] }))] }) })] }));
}
export default Schema;
//# sourceMappingURL=schema.js.map