import { z } from 'zod';
import { APIClient } from '../api';
declare const EvalRunSchema: z.ZodObject<{
    id: z.ZodString;
    sessionId: z.ZodString;
    evalId: z.ZodString;
    evalIdentifier: z.ZodNullable<z.ZodString>;
    evalName: z.ZodNullable<z.ZodString>;
    agentIdentifier: z.ZodNullable<z.ZodString>;
    projectId: z.ZodString;
    deploymentId: z.ZodNullable<z.ZodString>;
    devmode: z.ZodBoolean;
    pending: z.ZodBoolean;
    success: z.ZodBoolean;
    error: z.ZodNullable<z.ZodString>;
    result: z.ZodNullable<z.ZodAny>;
    createdAt: z.ZodString;
    updatedAt: z.ZodString;
}, z.core.$strip>;
export type EvalRunListItem = z.infer<typeof EvalRunSchema>;
export type EvalRunListRequest = {
    projectId?: string;
    agentId?: string;
    evalId?: string;
    sessionId?: string;
};
export declare function evalRunList(client: APIClient, request?: EvalRunListRequest): Promise<EvalRunListItem[]>;
export {};
//# sourceMappingURL=run-list.d.ts.map