import type { Schema, Infer } from '../base';
import { SCHEMA_KIND } from '../base';
/**
 * Schema for optional values (T | undefined).
 * Accepts undefined or the wrapped schema's type.
 *
 * @template T - The wrapped schema type
 *
 * @example
 * ```typescript
 * const schema = s.optional(s.string());
 * schema.parse('hello'); // 'hello'
 * schema.parse(undefined); // undefined
 * schema.parse(123); // throws ValidationError
 * ```
 */
export declare class OptionalSchema<T extends Schema<any, any>> implements Schema<Infer<T> | undefined, Infer<T> | undefined> {
    readonly [SCHEMA_KIND] = "OptionalSchema";
    readonly schema: T;
    description?: string;
    readonly '~standard': {
        version: 1;
        vendor: string;
        validate: (value: unknown) => import("@agentuity/core").StandardSchemaV1.Result<any> | Promise<import("@agentuity/core").StandardSchemaV1.Result<any>>;
        types: {
            input: Infer<T> | undefined;
            output: Infer<T> | undefined;
        };
    };
    private parseMethods;
    constructor(schema: T);
    describe(description: string): this;
    optional(): this;
    nullable(): Schema<Infer<T> | undefined | null, Infer<T> | undefined | null>;
    parse: (this: Schema<any, Infer<T> | undefined>, value: unknown) => Infer<T> | undefined;
    safeParse: (this: Schema<any, Infer<T> | undefined>, value: unknown) => import("..").SafeParseResult<Infer<T> | undefined>;
}
/**
 * Make a schema optional (T | undefined).
 *
 * @param schema - The schema to make optional
 *
 * @example
 * ```typescript
 * const userSchema = s.object({
 *   name: s.string(),
 *   nickname: s.optional(s.string())
 * });
 * ```
 */
export declare function optional<T extends Schema<any, any>>(schema: T): OptionalSchema<T>;
//# sourceMappingURL=optional.d.ts.map