import type { Schema } from '../base';
import { SCHEMA_KIND } from '../base';
/**
 * Schema that accepts any value with 'any' type.
 * Returns the value as-is without validation or type safety.
 * Use this sparingly - prefer unknown() for better type safety.
 *
 * @example
 * ```typescript
 * const schema = s.any();
 * const value = schema.parse(123); // any
 * const value2 = schema.parse('hello'); // any
 *
 * // No type checking required
 * value.toUpperCase(); // No error, but may fail at runtime
 * ```
 */
export declare class AnySchema implements Schema<any, any> {
    readonly [SCHEMA_KIND] = "AnySchema";
    description?: string;
    readonly '~standard': {
        version: 1;
        vendor: string;
        validate: (value: unknown) => import("@agentuity/core").StandardSchemaV1.SuccessResult<any>;
        types: {
            input: any;
            output: any;
        };
    };
    describe(description: string): this;
    optional(): import("..").OptionalSchema<this>;
    nullable(): import("..").NullableSchema<this>;
    parse: (this: Schema<any, any>, value: unknown) => any;
    safeParse: (this: Schema<any, any>, value: unknown) => import("..").SafeParseResult<any>;
}
/**
 * Create an any schema that accepts any value.
 *
 * @example
 * ```typescript
 * const schema = s.any();
 * const value = schema.parse(anything); // Type is any
 * ```
 */
export declare function any(): AnySchema;
//# sourceMappingURL=any.d.ts.map