import type { Database } from 'bun:sqlite';
import type { StreamStorage, Stream, CreateStreamProps, ListStreamsParams, ListStreamsResponse, StreamInfo } from '@agentuity/core';
export declare class LocalStreamStorage implements StreamStorage {
    #private;
    constructor(db: Database, projectPath: string, serverUrl: string);
    create(name: string, props?: CreateStreamProps): Promise<Stream>;
    list(params?: ListStreamsParams): Promise<ListStreamsResponse>;
    get(id: string): Promise<StreamInfo>;
    download(id: string): Promise<ReadableStream<Uint8Array>>;
    delete(id: string): Promise<void>;
}
//# sourceMappingURL=stream.d.ts.map