import { type ExportResult } from '@opentelemetry/core';
import type { ReadableSpan, SpanExporter } from '@opentelemetry/sdk-trace-base';
/**
 * JSONL implementation of the SpanExporter interface
 * Writes traces to a timestamped JSONL file
 */
export declare class JSONLTraceExporter implements SpanExporter {
    private currentFile;
    private readonly basePath;
    private readonly filePrefix;
    /**
     * Creates a new JSONL trace exporter
     * @param basePath - Directory to store the JSONL files
     */
    constructor(basePath: string);
    private ensureDirectory;
    private getOrCreateFile;
    /**
     * Exports spans to a JSONL file
     *
     * @param spans - The spans to export
     * @param resultCallback - Callback function to report the export result
     */
    export(spans: ReadableSpan[], resultCallback: (result: ExportResult) => void): void;
    /**
     * Shuts down the exporter
     *
     * @returns A promise that resolves when shutdown is complete
     */
    shutdown(): Promise<void>;
    /**
     * Forces a flush of any pending data
     */
    forceFlush(): Promise<void>;
}
//# sourceMappingURL=jsonl-trace-exporter.d.ts.map