import { z } from 'zod';
export const AgentRoleSchema = z.enum(['lead', 'scout', 'builder', 'reviewer', 'memory', 'expert']);
export const TaskStatusSchema = z.enum(['pending', 'running', 'completed', 'failed', 'cancelled']);
export const OrchestrationPatternSchema = z.enum(['single', 'fanout', 'pipeline']);
export const CadenceStatusSchema = z.enum([
    'running',
    'paused',
    'completed',
    'failed',
    'cancelled',
]);
export const CadenceSandboxModeSchema = z.enum(['off', 'per_iteration', 'persistent']);
export const CoderConfigSchema = z.object({
    org: z.string().optional(),
    agents: z
        .record(AgentRoleSchema, z.object({
        model: z.string().optional(),
        temperature: z.number().min(0).max(2).optional(),
    }))
        .optional(),
    disabledMcps: z.array(z.string()).optional(),
    blockedCommands: z.array(z.string()).optional(),
});
// ToolDefinition is re-exported from @opencode-ai/plugin above
//# sourceMappingURL=types.js.map