import { z } from 'zod';
export type { Plugin, PluginInput, Hooks as PluginHooks, ToolDefinition, } from '@opencode-ai/plugin';
export declare const AgentRoleSchema: z.ZodEnum<{
    lead: "lead";
    scout: "scout";
    builder: "builder";
    reviewer: "reviewer";
    memory: "memory";
    expert: "expert";
}>;
export type AgentRole = z.infer<typeof AgentRoleSchema>;
export declare const TaskStatusSchema: z.ZodEnum<{
    pending: "pending";
    running: "running";
    completed: "completed";
    failed: "failed";
    cancelled: "cancelled";
}>;
export type TaskStatus = z.infer<typeof TaskStatusSchema>;
export declare const OrchestrationPatternSchema: z.ZodEnum<{
    single: "single";
    fanout: "fanout";
    pipeline: "pipeline";
}>;
export type OrchestrationPattern = z.infer<typeof OrchestrationPatternSchema>;
export declare const CadenceStatusSchema: z.ZodEnum<{
    running: "running";
    completed: "completed";
    failed: "failed";
    cancelled: "cancelled";
    paused: "paused";
}>;
export type CadenceStatus = z.infer<typeof CadenceStatusSchema>;
export declare const CadenceSandboxModeSchema: z.ZodEnum<{
    off: "off";
    per_iteration: "per_iteration";
    persistent: "persistent";
}>;
export type CadenceSandboxMode = z.infer<typeof CadenceSandboxModeSchema>;
export interface CadenceLoop {
    loopId: string;
    parentId?: string;
    projectLabel?: string;
    sessionId?: string;
    status: CadenceStatus;
    iteration: number;
    maxIterations: number;
    prompt: string;
    createdAt: string;
    updatedAt: string;
    lastError?: string;
    sandbox?: {
        mode: CadenceSandboxMode;
        sandboxId?: string;
    };
}
export interface AgentConfig {
    /** Agent description - explains what it does and when to use it */
    description: string;
    /** Model ID in provider/model-id format */
    model: string;
    /** System prompt content (not a file path) */
    prompt: string;
    /** Agent mode: 'primary', 'subagent', or 'all' (default) */
    mode?: 'primary' | 'subagent' | 'all';
    /** Tool configuration */
    tools?: Record<string, boolean>;
    /** Model variant for thinking/reasoning (e.g., 'high', 'max' for Anthropic) */
    variant?: string;
    /** Temperature for response creativity (0.0-2.0) */
    temperature?: number;
    /** Maximum agentic steps before forcing text response */
    maxSteps?: number;
}
export interface AgentContext {
    projectRoot: string;
    orgId?: string;
    sessionId?: string;
    taskId?: string;
}
export interface CoderTask {
    id: string;
    title: string;
    description?: string;
    status: TaskStatus;
    createdAt: Date;
    updatedAt: Date;
    assignedTo?: AgentRole;
    parentTaskId?: string;
    result?: string;
    error?: string;
}
export interface CoderConfig {
    org?: string;
    agents?: Partial<Record<AgentRole, AgentModelConfig>>;
    disabledMcps?: string[];
    /** CLI command patterns to block for security (e.g., 'cloud secrets', 'auth token') */
    blockedCommands?: string[];
}
export interface AgentModelConfig {
    model?: string;
    temperature?: number;
}
export declare const CoderConfigSchema: z.ZodObject<{
    org: z.ZodOptional<z.ZodString>;
    agents: z.ZodOptional<z.ZodRecord<z.ZodEnum<{
        lead: "lead";
        scout: "scout";
        builder: "builder";
        reviewer: "reviewer";
        memory: "memory";
        expert: "expert";
    }>, z.ZodObject<{
        model: z.ZodOptional<z.ZodString>;
        temperature: z.ZodOptional<z.ZodNumber>;
    }, z.core.$strip>>>;
    disabledMcps: z.ZodOptional<z.ZodArray<z.ZodString>>;
    blockedCommands: z.ZodOptional<z.ZodArray<z.ZodString>>;
}, z.core.$strip>;
export interface McpConfig {
    name: string;
    type: 'remote';
    url: string;
    enabled: boolean;
    headers?: Record<string, string>;
}
export interface CommandDefinition {
    name: string;
    description?: string;
    template: string;
    agent?: string;
    model?: string;
    argumentHint?: string;
    /** Force command to run as subagent for context isolation */
    subtask?: boolean;
}
//# sourceMappingURL=types.d.ts.map