import { leadAgent } from './lead';
import { scoutAgent } from './scout';
import { builderAgent } from './builder';
import { reviewerAgent } from './reviewer';
import { memoryAgent } from './memory';
import { expertAgent } from './expert';
export const agents = {
    lead: leadAgent,
    scout: scoutAgent,
    builder: builderAgent,
    reviewer: reviewerAgent,
    memory: memoryAgent,
    expert: expertAgent,
};
export function getAgent(role) {
    return agents[role];
}
export function getAgentByRole(role) {
    return agents[role];
}
export function getAgentById(id) {
    return Object.values(agents).find((a) => a.id === id);
}
export function getAllAgents() {
    return Object.values(agents);
}
export function createAgentRegistry() {
    return {
        get(role) {
            return agents[role];
        },
        getAll() {
            return Object.values(agents);
        },
        has(role) {
            return role in agents;
        },
    };
}
//# sourceMappingURL=index.js.map