import { APIClient } from '../api';
import type { ListRuntimesParams, ListRuntimesResponse } from '@agentuity/core';
export interface RuntimeListParams extends ListRuntimesParams {
    orgId?: string;
}
/**
 * Lists available sandbox runtimes with optional pagination.
 *
 * @param client - The API client to use for the request
 * @param params - Optional parameters for pagination
 * @returns List of runtimes with total count
 * @throws {SandboxResponseError} If the request fails
 */
export declare function runtimeList(client: APIClient, params?: RuntimeListParams): Promise<ListRuntimesResponse>;
//# sourceMappingURL=runtime.d.ts.map