/**
 * Color utilities for TUI components using existing tui.ts color system
 */
// ANSI escape codes for additional colors not in main tui.ts
const RESET = '\x1b[0m';
const CYAN = '\x1b[36m';
const GRAY = '\x1b[90m';
const RED = '\x1b[31m';
const YELLOW = '\x1b[33m';
const GREEN = '\x1b[32m';
const BLUE = '\x1b[34m';
const DIM = '\x1b[2m';
const BOLD = '\x1b[1m';
const UNDERLINE = '\x1b[4m';
const BG_CYAN = '\x1b[46m';
const BLACK = '\x1b[30m';
const WHITE = '\x1b[37m';
/**
 * Detect if terminal is in dark mode
 */
function isDarkMode() {
    const scheme = process.env.COLOR_SCHEME;
    if (scheme === 'light')
        return false;
    if (scheme === 'dark')
        return true;
    return true;
}
export const colors = {
    // State colors - using simple ANSI codes (consistent with tui.ts approach)
    active: (text) => `${CYAN}${text}${RESET}`,
    completed: (text) => `${GRAY}${text}${RESET}`,
    error: (text) => `${RED}${text}${RESET}`,
    warning: (text) => `${YELLOW}${text}${RESET}`,
    success: (text) => `${GREEN}${text}${RESET}`,
    info: (text) => `${BLUE}${text}${RESET}`,
    // Text formatting
    muted: (text) => `${DIM}${text}${RESET}`,
    bold: (text) => `${BOLD}${text}${RESET}`,
    underline: (text) => `${UNDERLINE}${text}${RESET}`,
    reset: (text) => `${RESET}${text}`,
    // Semantic colors
    primary: (text) => `${CYAN}${text}${RESET}`,
    secondary: (text) => `${GRAY}${text}${RESET}`,
    link: (text) => `${CYAN}${UNDERLINE}${text}${RESET}`,
    // Inversed colors (adapt to light/dark mode)
    inverseCyan: (text) => {
        const dark = isDarkMode();
        return dark ? `${BG_CYAN}${BLACK}${text}${RESET}` : `${BG_CYAN}${WHITE}${text}${RESET}`;
    },
};
//# sourceMappingURL=colors.js.map