import type { APIClient } from '../../../api';
export interface SSHKey {
    fingerprint: string;
    keyType: string;
    comment: string;
    publicKey: string;
}
export interface AddSSHKeyResult {
    fingerprint: string;
    added: boolean;
}
export declare function computeSSHKeyFingerprint(publicKey: string): string;
export declare function addSSHKey(apiClient: APIClient, publicKey: string): Promise<AddSSHKeyResult>;
export declare function listSSHKeys(apiClient: APIClient): Promise<SSHKey[]>;
export declare function removeSSHKey(apiClient: APIClient, fingerprint: string): Promise<boolean>;
//# sourceMappingURL=api.d.ts.map