import type { Logger } from '../types';
export interface UpgradeResult {
    upgraded: string[];
    skipped: string[];
    failed: string[];
}
/**
 * Checks if a version specifier should be upgraded
 * @param specifier - The version specifier from package.json (e.g., "latest", "^1.0.0", "1.2.3")
 * @returns true if the package should be upgraded
 */
export declare function shouldUpgradeVersion(specifier: string): boolean;
/**
 * Check and upgrade @agentuity/* dependencies to match CLI version
 * @param projectDir - Root directory of the user's project
 * @param logger - Logger instance
 * @returns Result of the upgrade operation
 */
export declare function checkAndUpgradeDependencies(projectDir: string, logger: Logger): Promise<UpgradeResult>;
//# sourceMappingURL=dependency-checker.d.ts.map