import { z } from 'zod';
import { APIClient } from '../api';
declare const SnapshotFileInfoSchema: z.ZodObject<{
    path: z.ZodString;
    size: z.ZodNumber;
    sha256: z.ZodString;
    contentType: z.ZodString;
    mode: z.ZodNumber;
}, z.core.$strip>;
declare const SnapshotInfoSchema: z.ZodObject<{
    snapshotId: z.ZodString;
    runtimeId: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    name: z.ZodString;
    fullName: z.ZodOptional<z.ZodString>;
    description: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    message: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    tag: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    sizeBytes: z.ZodNumber;
    fileCount: z.ZodNumber;
    parentSnapshotId: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    public: z.ZodOptional<z.ZodBoolean>;
    orgName: z.ZodOptional<z.ZodString>;
    orgSlug: z.ZodOptional<z.ZodString>;
    org: z.ZodOptional<z.ZodNullable<z.ZodObject<{
        id: z.ZodString;
        name: z.ZodString;
        slug: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    }, z.core.$strip>>>;
    user: z.ZodOptional<z.ZodNullable<z.ZodObject<{
        id: z.ZodString;
        firstName: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        lastName: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    }, z.core.$strip>>>;
    createdAt: z.ZodString;
    downloadUrl: z.ZodOptional<z.ZodString>;
    files: z.ZodOptional<z.ZodNullable<z.ZodArray<z.ZodObject<{
        path: z.ZodString;
        size: z.ZodNumber;
        sha256: z.ZodString;
        contentType: z.ZodString;
        mode: z.ZodNumber;
    }, z.core.$strip>>>>;
    userMetadata: z.ZodOptional<z.ZodNullable<z.ZodRecord<z.ZodString, z.ZodString>>>;
}, z.core.$strip>;
declare const SnapshotListDataSchema: z.ZodObject<{
    snapshots: z.ZodArray<z.ZodObject<{
        snapshotId: z.ZodString;
        runtimeId: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        name: z.ZodString;
        fullName: z.ZodOptional<z.ZodString>;
        description: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        message: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        tag: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        sizeBytes: z.ZodNumber;
        fileCount: z.ZodNumber;
        parentSnapshotId: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        public: z.ZodOptional<z.ZodBoolean>;
        orgName: z.ZodOptional<z.ZodString>;
        orgSlug: z.ZodOptional<z.ZodString>;
        org: z.ZodOptional<z.ZodNullable<z.ZodObject<{
            id: z.ZodString;
            name: z.ZodString;
            slug: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        }, z.core.$strip>>>;
        user: z.ZodOptional<z.ZodNullable<z.ZodObject<{
            id: z.ZodString;
            firstName: z.ZodOptional<z.ZodNullable<z.ZodString>>;
            lastName: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        }, z.core.$strip>>>;
        createdAt: z.ZodString;
        downloadUrl: z.ZodOptional<z.ZodString>;
        files: z.ZodOptional<z.ZodNullable<z.ZodArray<z.ZodObject<{
            path: z.ZodString;
            size: z.ZodNumber;
            sha256: z.ZodString;
            contentType: z.ZodString;
            mode: z.ZodNumber;
        }, z.core.$strip>>>>;
        userMetadata: z.ZodOptional<z.ZodNullable<z.ZodRecord<z.ZodString, z.ZodString>>>;
    }, z.core.$strip>>;
    total: z.ZodNumber;
}, z.core.$strip>;
declare const SnapshotLineageEntrySchema: z.ZodObject<{
    snapshotId: z.ZodString;
    name: z.ZodString;
    fullName: z.ZodOptional<z.ZodString>;
    message: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    tag: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    parentSnapshotId: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    public: z.ZodBoolean;
    deleted: z.ZodOptional<z.ZodBoolean>;
    org: z.ZodOptional<z.ZodNullable<z.ZodObject<{
        id: z.ZodString;
        name: z.ZodString;
        slug: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    }, z.core.$strip>>>;
    user: z.ZodOptional<z.ZodNullable<z.ZodObject<{
        id: z.ZodString;
        firstName: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        lastName: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    }, z.core.$strip>>>;
    createdAt: z.ZodString;
}, z.core.$strip>;
declare const SnapshotLineageDataSchema: z.ZodObject<{
    lineage: z.ZodArray<z.ZodObject<{
        snapshotId: z.ZodString;
        name: z.ZodString;
        fullName: z.ZodOptional<z.ZodString>;
        message: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        tag: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        parentSnapshotId: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        public: z.ZodBoolean;
        deleted: z.ZodOptional<z.ZodBoolean>;
        org: z.ZodOptional<z.ZodNullable<z.ZodObject<{
            id: z.ZodString;
            name: z.ZodString;
            slug: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        }, z.core.$strip>>>;
        user: z.ZodOptional<z.ZodNullable<z.ZodObject<{
            id: z.ZodString;
            firstName: z.ZodOptional<z.ZodNullable<z.ZodString>>;
            lastName: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        }, z.core.$strip>>>;
        createdAt: z.ZodString;
    }, z.core.$strip>>;
    total: z.ZodNumber;
}, z.core.$strip>;
export type SnapshotFileInfo = z.infer<typeof SnapshotFileInfoSchema>;
export type SnapshotInfo = z.infer<typeof SnapshotInfoSchema>;
export type SnapshotListResponse = z.infer<typeof SnapshotListDataSchema>;
export type SnapshotLineageEntry = z.infer<typeof SnapshotLineageEntrySchema>;
export type SnapshotLineageResponse = z.infer<typeof SnapshotLineageDataSchema>;
declare const _SnapshotCreateParamsSchema: z.ZodObject<{
    sandboxId: z.ZodString;
    name: z.ZodOptional<z.ZodString>;
    description: z.ZodOptional<z.ZodString>;
    tag: z.ZodOptional<z.ZodString>;
    public: z.ZodOptional<z.ZodBoolean>;
    orgId: z.ZodOptional<z.ZodString>;
}, z.core.$strip>;
declare const _SnapshotGetParamsSchema: z.ZodObject<{
    snapshotId: z.ZodString;
    orgId: z.ZodOptional<z.ZodString>;
}, z.core.$strip>;
declare const _SnapshotListParamsSchema: z.ZodObject<{
    sandboxId: z.ZodOptional<z.ZodString>;
    limit: z.ZodOptional<z.ZodNumber>;
    offset: z.ZodOptional<z.ZodNumber>;
    orgId: z.ZodOptional<z.ZodString>;
}, z.core.$strip>;
declare const _SnapshotDeleteParamsSchema: z.ZodObject<{
    snapshotId: z.ZodString;
    orgId: z.ZodOptional<z.ZodString>;
}, z.core.$strip>;
declare const _SnapshotTagParamsSchema: z.ZodObject<{
    snapshotId: z.ZodString;
    tag: z.ZodNullable<z.ZodString>;
    orgId: z.ZodOptional<z.ZodString>;
}, z.core.$strip>;
declare const _SnapshotLineageParamsSchema: z.ZodObject<{
    snapshot: z.ZodOptional<z.ZodString>;
    name: z.ZodOptional<z.ZodString>;
    tag: z.ZodOptional<z.ZodString>;
    limit: z.ZodOptional<z.ZodNumber>;
    orgId: z.ZodOptional<z.ZodString>;
}, z.core.$strip>;
export type SnapshotCreateParams = z.infer<typeof _SnapshotCreateParamsSchema>;
export type SnapshotGetParams = z.infer<typeof _SnapshotGetParamsSchema>;
export type SnapshotListParams = z.infer<typeof _SnapshotListParamsSchema>;
export type SnapshotDeleteParams = z.infer<typeof _SnapshotDeleteParamsSchema>;
export type SnapshotTagParams = z.infer<typeof _SnapshotTagParamsSchema>;
export type SnapshotLineageParams = z.infer<typeof _SnapshotLineageParamsSchema>;
/**
 * Creates a snapshot of a sandbox's current state.
 *
 * @param client - The API client to use for the request
 * @param params - Parameters including sandbox ID and optional tag
 * @returns The created snapshot information
 * @throws {SandboxResponseError} If the snapshot creation fails
 */
export declare function snapshotCreate(client: APIClient, params: SnapshotCreateParams): Promise<SnapshotInfo>;
/**
 * Retrieves detailed information about a specific snapshot.
 *
 * @param client - The API client to use for the request
 * @param params - Parameters including the snapshot ID
 * @returns Snapshot information including files and download URL
 * @throws {SandboxResponseError} If the snapshot is not found or request fails
 */
export declare function snapshotGet(client: APIClient, params: SnapshotGetParams): Promise<SnapshotInfo>;
/**
 * Lists snapshots with optional filtering and pagination.
 *
 * @param client - The API client to use for the request
 * @param params - Optional parameters for filtering by sandbox and pagination
 * @returns Paginated list of snapshots with total count
 * @throws {SandboxResponseError} If the request fails
 */
export declare function snapshotList(client: APIClient, params?: SnapshotListParams): Promise<SnapshotListResponse>;
/**
 * Deletes a snapshot and releases its storage.
 *
 * @param client - The API client to use for the request
 * @param params - Parameters including the snapshot ID to delete
 * @throws {SandboxResponseError} If the snapshot is not found or deletion fails
 */
export declare function snapshotDelete(client: APIClient, params: SnapshotDeleteParams): Promise<void>;
/**
 * Updates or removes the tag on a snapshot.
 *
 * @param client - The API client to use for the request
 * @param params - Parameters including snapshot ID and new tag (or null to remove)
 * @returns Updated snapshot information
 * @throws {SandboxResponseError} If the snapshot is not found or update fails
 */
export declare function snapshotTag(client: APIClient, params: SnapshotTagParams): Promise<SnapshotInfo>;
/**
 * Gets the lineage (ancestry chain) of a snapshot.
 *
 * Returns an ordered list of snapshots from the specified snapshot (or latest by name)
 * walking back through parentSnapshotId references to the root.
 *
 * @param client - The API client to use for the request
 * @param params - Parameters specifying which snapshot to get lineage for
 * @returns Ordered list of snapshots in the lineage (newest to oldest)
 * @throws {SandboxResponseError} If the snapshot is not found or request fails
 *
 * @example
 * // Get lineage starting from a specific snapshot ID
 * const lineage = await snapshotLineage(client, { snapshot: 'snp_abc123' });
 *
 * @example
 * // Get lineage starting from the latest snapshot with a given name
 * const lineage = await snapshotLineage(client, { name: 'myapp' });
 *
 * @example
 * // Get lineage starting from a specific name:tag
 * const lineage = await snapshotLineage(client, { name: 'myapp', tag: 'v1.0.0' });
 */
export declare function snapshotLineage(client: APIClient, params: SnapshotLineageParams): Promise<SnapshotLineageResponse>;
declare const _SnapshotPublicListParamsSchema: z.ZodObject<{
    limit: z.ZodOptional<z.ZodNumber>;
    offset: z.ZodOptional<z.ZodNumber>;
}, z.core.$strip>;
export type SnapshotPublicListParams = z.infer<typeof _SnapshotPublicListParamsSchema>;
declare const _SnapshotPublicGetParamsSchema: z.ZodObject<{
    snapshotRef: z.ZodString;
}, z.core.$strip>;
export type SnapshotPublicGetParams = z.infer<typeof _SnapshotPublicGetParamsSchema>;
/**
 * Gets a public snapshot without requiring authentication.
 *
 * Supports multiple reference formats:
 * - Snapshot ID: `snp_abc123`
 * - Full name with org slug: `@myorg/myimage:latest`
 * - Simple name:tag: `myimage:v1.0`
 *
 * @param client - The API client to use for the request
 * @param params - Parameters including the snapshot reference
 * @returns Snapshot information including files and download URL
 * @throws {SandboxResponseError} If the snapshot is not found or is not public
 *
 * @example
 * // Get by snapshot ID
 * const snapshot = await snapshotPublicGet(client, { snapshotRef: 'snp_abc123' });
 *
 * @example
 * // Get by full name with org slug
 * const snapshot = await snapshotPublicGet(client, { snapshotRef: '@agentuity/bun:latest' });
 *
 * @example
 * // Get by name:tag
 * const snapshot = await snapshotPublicGet(client, { snapshotRef: 'bun:1.2' });
 */
export declare function snapshotPublicGet(client: APIClient, params: SnapshotPublicGetParams): Promise<SnapshotInfo>;
/**
 * Lists all public snapshots across the platform.
 *
 * Returns paginated list of snapshots that have been marked as public,
 * regardless of which organization owns them.
 *
 * @param client - The API client to use for the request
 * @param params - Optional parameters for pagination
 * @returns Paginated list of public snapshots with total count
 * @throws {SandboxResponseError} If the request fails
 *
 * @example
 * // List first page of public snapshots
 * const result = await snapshotPublicList(client);
 * console.log(result.snapshots);
 *
 * @example
 * // List with pagination
 * const result = await snapshotPublicList(client, { limit: 20, offset: 40 });
 */
export declare function snapshotPublicList(client: APIClient, params?: SnapshotPublicListParams): Promise<SnapshotListResponse>;
/**
 * Git information for snapshot builds
 */
declare const SnapshotBuildGitInfoSchema: z.ZodObject<{
    branch: z.ZodOptional<z.ZodString>;
    commit: z.ZodOptional<z.ZodString>;
    repo: z.ZodOptional<z.ZodString>;
    provider: z.ZodOptional<z.ZodString>;
    commitUrl: z.ZodOptional<z.ZodString>;
}, z.core.$strip>;
declare const _SnapshotBuildInitParamsSchema: z.ZodObject<{
    runtime: z.ZodString;
    name: z.ZodOptional<z.ZodString>;
    tag: z.ZodOptional<z.ZodString>;
    description: z.ZodOptional<z.ZodString>;
    message: z.ZodOptional<z.ZodString>;
    git: z.ZodOptional<z.ZodObject<{
        branch: z.ZodOptional<z.ZodString>;
        commit: z.ZodOptional<z.ZodString>;
        repo: z.ZodOptional<z.ZodString>;
        provider: z.ZodOptional<z.ZodString>;
        commitUrl: z.ZodOptional<z.ZodString>;
    }, z.core.$strip>>;
    contentHash: z.ZodOptional<z.ZodString>;
    force: z.ZodOptional<z.ZodBoolean>;
    encrypt: z.ZodOptional<z.ZodBoolean>;
    public: z.ZodOptional<z.ZodBoolean>;
    orgId: z.ZodOptional<z.ZodString>;
}, z.core.$strip>;
export type SnapshotBuildGitInfo = z.infer<typeof SnapshotBuildGitInfoSchema>;
declare const SnapshotBuildInitResponseSchema: z.ZodObject<{
    snapshotId: z.ZodOptional<z.ZodString>;
    uploadUrl: z.ZodOptional<z.ZodString>;
    publicKey: z.ZodOptional<z.ZodString>;
    unchanged: z.ZodOptional<z.ZodBoolean>;
    existingId: z.ZodOptional<z.ZodString>;
    existingName: z.ZodOptional<z.ZodString>;
    existingTag: z.ZodOptional<z.ZodString>;
}, z.core.$strip>;
declare const _SnapshotBuildFinalizeParamsSchema: z.ZodObject<{
    snapshotId: z.ZodString;
    sizeBytes: z.ZodNumber;
    fileCount: z.ZodNumber;
    files: z.ZodArray<z.ZodObject<{
        path: z.ZodString;
        size: z.ZodNumber;
        sha256: z.ZodString;
        contentType: z.ZodString;
        mode: z.ZodNumber;
    }, z.core.$strip>>;
    dependencies: z.ZodOptional<z.ZodArray<z.ZodString>>;
    env: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
    metadata: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
    orgId: z.ZodOptional<z.ZodString>;
}, z.core.$strip>;
export type SnapshotBuildInitParams = z.infer<typeof _SnapshotBuildInitParamsSchema>;
export type SnapshotBuildInitResponse = z.infer<typeof SnapshotBuildInitResponseSchema>;
export type SnapshotBuildFinalizeParams = z.infer<typeof _SnapshotBuildFinalizeParamsSchema>;
/**
 * Initialize a snapshot build by getting a presigned upload URL.
 *
 * @param client - The API client to use for the request
 * @param params - Parameters including runtime and optional name/tag/description
 * @returns Snapshot ID and presigned upload URL
 * @throws {SandboxResponseError} If the initialization fails
 */
export declare function snapshotBuildInit(client: APIClient, params: SnapshotBuildInitParams): Promise<SnapshotBuildInitResponse>;
/**
 * Finalize a snapshot build after uploading the archive.
 *
 * @param client - The API client to use for the request
 * @param params - Parameters including snapshot details and file metadata
 * @returns The created snapshot information
 * @throws {SandboxResponseError} If the finalization fails
 */
export declare function snapshotBuildFinalize(client: APIClient, params: SnapshotBuildFinalizeParams): Promise<SnapshotInfo>;
declare const SnapshotUploadResponseSchema: z.ZodObject<{
    success: z.ZodBoolean;
    scanned: z.ZodBoolean;
    message: z.ZodOptional<z.ZodString>;
}, z.core.$strip>;
export type SnapshotUploadResponse = z.infer<typeof SnapshotUploadResponseSchema>;
export interface SnapshotUploadParams {
    snapshotId: string;
    body: Uint8Array | ArrayBuffer | ReadableStream<Uint8Array> | string | Blob;
    contentLength: number;
    orgId?: string;
}
/**
 * Upload a public snapshot archive via Catalyst (with virus scanning).
 * This should only be used when snapshotBuildInit returns no uploadUrl.
 *
 * @param client - The API client to use for the request
 * @param params - Parameters including snapshotId and the archive body
 * @returns Upload result with scan status
 * @throws {SandboxResponseError} If the upload fails or malware is detected
 */
export declare function snapshotUpload(client: APIClient, params: SnapshotUploadParams): Promise<SnapshotUploadResponse>;
export {};
//# sourceMappingURL=snapshot.d.ts.map