import type { PluginContext, CoderConfig } from '../../types';
export interface CadenceHooks {
    onMessage: (input: unknown, output: unknown) => Promise<void>;
    onEvent: (input: unknown) => Promise<void>;
}
/**
 * Cadence hooks track which sessions are in long-running Cadence mode.
 *
 * The actual continuation logic is agentic - Lead manages its own state and
 * continuation via KV storage and the Cadence mode instructions in its prompt.
 * These hooks primarily:
 * 1. Detect when Cadence mode starts (via command or [CADENCE MODE] tag)
 * 2. Detect when Cadence completes (via <promise>DONE</promise>)
 * 3. Clean up on session abort/error
 */
export declare function createCadenceHooks(ctx: PluginContext, _config: CoderConfig): CadenceHooks;
//# sourceMappingURL=cadence.d.ts.map