import { $ } from 'bun';
export async function extractDependencies(projectDir, logger) {
    try {
        logger.debug('Extracting dependencies using bun pm ls --all');
        const result = await $ `bun pm ls --all`.cwd(projectDir).quiet().nothrow();
        if (result.exitCode !== 0) {
            logger.warn('Failed to extract dependencies: bun pm ls exited with code %d', result.exitCode);
            return [];
        }
        const output = result.stdout.toString();
        const packages = parseBunPmLsOutput(output);
        logger.debug('Extracted %d unique packages', packages.length);
        return packages;
    }
    catch (error) {
        logger.warn('Failed to extract dependencies: %s', error);
        return [];
    }
}
export function parseBunPmLsOutput(output) {
    const packages = new Map();
    const lines = output.split('\n');
    for (const line of lines) {
        const match = line.match(/([^\s]+)@(\d+\.\d+\.\d+[^\s]*)/);
        if (match) {
            const name = match[1];
            const version = match[2];
            const key = `${name}@${version}`;
            if (!packages.has(key)) {
                packages.set(key, { name, version });
            }
        }
    }
    return Array.from(packages.values());
}
//# sourceMappingURL=deps.js.map