/**
 * Metadata Generator
 *
 * Generates agentuity.metadata.json and .routemapping.json from discovered agents and routes
 */
import type { BuildMetadata } from '@agentuity/server';
import type { AgentMetadata } from './agent-discovery';
import type { RouteMetadata } from './route-discovery';
import type { Logger, DeployOptions } from '../../../types';
export interface MetadataGeneratorOptions {
    rootDir: string;
    projectId: string;
    orgId?: string;
    deploymentId?: string;
    agents: AgentMetadata[];
    routes: RouteMetadata[];
    dev?: boolean;
    logger: Logger;
    deploymentOptions?: DeployOptions;
}
/**
 * Generate agentuity.metadata.json
 */
export declare function generateMetadata(options: MetadataGeneratorOptions): Promise<BuildMetadata>;
/**
 * Write agentuity.metadata.json to .agentuity directory
 */
export declare function writeMetadataFile(rootDir: string, metadata: BuildMetadata, dev: boolean, logger: Logger): void;
/**
 * Generate .routemapping.json for runtime route tracking
 */
export declare function generateRouteMapping(rootDir: string, routes: RouteMetadata[], dev: boolean, logger: Logger): void;
//# sourceMappingURL=metadata-generator.d.ts.map