import type { CommandContext, AuthData } from './types';
import { type APIClient as APIClientType } from './api';
export declare function isTTY(): boolean;
export declare function hasLoggedInBefore(): Promise<boolean>;
export declare function isAuthenticated(): Promise<boolean>;
export declare function requireAuth(ctx: CommandContext<undefined>): Promise<AuthData>;
export declare function optionalAuth(ctx: CommandContext<undefined>, continueText?: string, skipPrompts?: boolean): Promise<AuthData | null>;
export declare function requireOrg(ctx: CommandContext & {
    apiClient: APIClientType;
}): Promise<string>;
export declare function optionalOrg(ctx: CommandContext & {
    apiClient?: APIClientType;
    auth?: AuthData;
}): Promise<string | undefined>;
//# sourceMappingURL=auth.d.ts.map