import { useCallback } from 'react';
const getLogLevel = () => {
    try {
        const level = localStorage.getItem('AGENTUITY_LOG_LEVEL');
        if (level && ['debug', 'info', 'warn', 'error'].includes(level)) {
            return level;
        }
        return null;
    }
    catch {
        return null;
    }
};
const shouldLog = (messageLevel) => {
    const currentLevel = getLogLevel();
    if (!currentLevel)
        return false;
    const levels = {
        debug: 0,
        info: 1,
        warn: 2,
        error: 3,
    };
    return levels[messageLevel] >= levels[currentLevel];
};
export function useLogger(component) {
    const createLogFunction = useCallback((level) => (...args) => {
        if (!shouldLog(level)) {
            return;
        }
        const prefix = component ? `[${component}]` : '[Workbench]';
        const consoleFn = console[level] || console.log;
        consoleFn(prefix, ...args);
    }, [component]);
    return {
        debug: createLogFunction('debug'),
        info: createLogFunction('info'),
        warn: createLogFunction('warn'),
        error: createLogFunction('error'),
    };
}
//# sourceMappingURL=useLogger.js.map