import { z } from 'zod';
import { APIClient } from '../api';
declare const OrgEnvDataSchema: z.ZodObject<{
    id: z.ZodString;
    env: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
    secrets: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
}, z.core.$strip>;
interface OrgEnvGetRequest {
    id: string;
    mask?: boolean;
}
export type OrgEnv = z.infer<typeof OrgEnvDataSchema>;
/**
 * Get environment variables and secrets for an organization.
 * Secrets are masked by default unless mask=false is specified.
 * Note: Unmasked values require admin/owner role.
 */
export declare function orgEnvGet(client: APIClient, request: OrgEnvGetRequest): Promise<OrgEnv>;
export {};
//# sourceMappingURL=env-get.d.ts.map