import { z } from 'zod';
import { APIResponseSchema } from '../api';
const PackageRef = z.object({
    name: z.string(),
    version: z.string(),
});
const MalwareFinding = z.object({
    name: z.string(),
    version: z.string(),
    reason: z.string(),
});
const MalwareCheckSummary = z.object({
    scanned: z.number(),
    flagged: z.number(),
});
const MalwareCheckListMetadata = z.object({
    fetchedAt: z.string(),
    count: z.number(),
});
const MalwareCheckResult = z.object({
    success: z.boolean(),
    action: z.enum(['allow', 'block']),
    summary: MalwareCheckSummary,
    findings: z.array(MalwareFinding),
    list: MalwareCheckListMetadata.optional(),
    error: z.string().optional(),
});
const MalwareCheckResponseSchema = APIResponseSchema(MalwareCheckResult);
export async function projectDeploymentMalwareCheck(client, deploymentId, packages) {
    const resp = await client.request('POST', `/security/2026-01-22/${deploymentId}/malware-check`, MalwareCheckResponseSchema, {
        ecosystem: 'npm',
        packages,
    });
    if (!resp.success) {
        throw new Error(resp.message || 'Malware check request failed');
    }
    return resp.data;
}
//# sourceMappingURL=malware.js.map