import { z } from 'zod';
import { type APIClient } from '../api';
declare const PackageRef: z.ZodObject<{
    name: z.ZodString;
    version: z.ZodString;
}, z.core.$strip>;
export type PackageRef = z.infer<typeof PackageRef>;
declare const MalwareFinding: z.ZodObject<{
    name: z.ZodString;
    version: z.ZodString;
    reason: z.ZodString;
}, z.core.$strip>;
export type MalwareFinding = z.infer<typeof MalwareFinding>;
declare const MalwareCheckResult: z.ZodObject<{
    success: z.ZodBoolean;
    action: z.ZodEnum<{
        allow: "allow";
        block: "block";
    }>;
    summary: z.ZodObject<{
        scanned: z.ZodNumber;
        flagged: z.ZodNumber;
    }, z.core.$strip>;
    findings: z.ZodArray<z.ZodObject<{
        name: z.ZodString;
        version: z.ZodString;
        reason: z.ZodString;
    }, z.core.$strip>>;
    list: z.ZodOptional<z.ZodObject<{
        fetchedAt: z.ZodString;
        count: z.ZodNumber;
    }, z.core.$strip>>;
    error: z.ZodOptional<z.ZodString>;
}, z.core.$strip>;
export type MalwareCheckResult = z.infer<typeof MalwareCheckResult>;
export declare function projectDeploymentMalwareCheck(client: APIClient, deploymentId: string, packages: PackageRef[]): Promise<MalwareCheckResult>;
export {};
//# sourceMappingURL=malware.d.ts.map