import type { Context } from 'hono';
import type { AppState } from '../../index';
import type { Env } from '../../app';
import { type Thread, type ThreadIDProvider, type ThreadProvider } from '../../session';
/**
 * Local thread provider with SQLite persistence.
 * Stores thread state in local DB for development and testing.
 * Suitable for local development and testing with persistence across requests.
 */
export declare class LocalThreadProvider implements ThreadProvider {
    private appState;
    private threadIDProvider;
    private db;
    initialize(appState: AppState): Promise<void>;
    setThreadIDProvider(provider: ThreadIDProvider): void;
    restore(ctx: Context<Env>): Promise<Thread>;
    save(thread: Thread): Promise<void>;
    destroy(thread: Thread): Promise<void>;
}
//# sourceMappingURL=local.d.ts.map