/**
 * Message handler callback type
 */
export type MessageHandler<T = unknown> = (data: T) => void;
/**
 * EventStream state change callback types
 */
export interface EventStreamCallbacks<TOutput = unknown> {
    /** Called when connection is established */
    onConnect?: () => void;
    /** Called when connection is closed */
    onDisconnect?: () => void;
    /** Called when an error occurs */
    onError?: (error: Error) => void;
    /** Called when a message is received */
    onMessage?: MessageHandler<TOutput>;
}
/**
 * Options for EventStreamManager
 */
export interface EventStreamManagerOptions<TOutput = unknown> {
    /** EventStream URL */
    url: string;
    /** Callbacks for state changes */
    callbacks?: EventStreamCallbacks<TOutput>;
    /** Reconnection configuration */
    reconnect?: {
        threshold?: number;
        baseDelay?: number;
        factor?: number;
        maxDelay?: number;
        jitter?: number;
    };
}
/**
 * EventStream manager state
 */
export interface EventStreamManagerState {
    /** Whether EventStream is currently connected */
    isConnected: boolean;
    /** Current error, if any */
    error: Error | null;
    /** EventStream ready state */
    readyState: number;
}
/**
 * Generic EventStream (SSE) connection manager with automatic reconnection
 * and handler management.
 *
 * Framework-agnostic - can be used with React, Svelte, Vue, or vanilla JS.
 */
export declare class EventStreamManager<TOutput = unknown> {
    private es;
    private manualClose;
    private pendingMessages;
    private messageHandler;
    private reconnectManager;
    private callbacks;
    private url;
    private reconnectConfig;
    private firstMessageReceived;
    constructor(options: EventStreamManagerOptions<TOutput>);
    /**
     * Connect to the EventStream server
     */
    connect(): void;
    /**
     * Set the message handler.
     * Any buffered messages will be delivered immediately.
     */
    setMessageHandler(handler: MessageHandler<TOutput>): void;
    /**
     * Get current state
     */
    getState(): EventStreamManagerState;
    /**
     * Close the EventStream connection and cleanup
     */
    close(): void;
    /**
     * Dispose of the manager (alias for close)
     */
    dispose(): void;
}
//# sourceMappingURL=eventstream-manager.d.ts.map