import { APIResponseSchema } from '@agentuity/server';
import { z } from 'zod';
import { StructuredError } from '@agentuity/core';
const DevmodeRequestSchema = z.object({
    hostname: z.string().optional().describe('the hostname for the endpoint'),
});
const DevmodeResponseSchema = z.object({
    id: z.string(),
    hostname: z.string(),
});
const DevmodeResponseAPISchema = APIResponseSchema(DevmodeResponseSchema);
const DevmodeEndpointError = StructuredError('DevmodeEndpointError');
/**
 * Generate an Endpoint ID and Hostname
 *
 * @param apiClient the api client to use
 * @param projectId the project id
 * @param hostname the hostname is already configured
 * @returns
 */
export async function generateEndpoint(apiClient, projectId, hostname) {
    const resp = await apiClient.request('POST', `/cli/devmode/2/${projectId}`, DevmodeResponseAPISchema, { hostname }, DevmodeRequestSchema);
    if (!resp.success) {
        throw new DevmodeEndpointError({ message: resp.message });
    }
    return resp.data;
}
//# sourceMappingURL=api.js.map