import { getGlobalCatalystAPIClient } from '../../../config';
/**
 * Creates an API client for queue operations.
 *
 * Queues are global resources that don't require a project context.
 * Uses the global Catalyst API client with user authentication.
 */
export async function createQueueAPIClient(ctx) {
    return getGlobalCatalystAPIClient(ctx.logger, ctx.auth, ctx.config?.name);
}
/**
 * Creates QueueApiOptions from the CLI context.
 * Prioritizes explicit orgId on context, then falls back to global --org-id option.
 */
export function getQueueApiOptions(ctx) {
    const orgId = ctx.orgId ?? ctx.options.orgId;
    return orgId ? { orgId } : undefined;
}
//# sourceMappingURL=util.js.map