import { generateEnvGuard, generateGatewayEnvGuard } from './_util';
function registerLLMPatch(patches, module, filename, key, baseurl, name) {
    patches.set(module, {
        module,
        filename,
        body: {
            before: generateEnvGuard(key, generateGatewayEnvGuard(key, 'process.env.AGENTUITY_SDK_KEY', baseurl, name)),
        },
    });
}
export function generatePatches() {
    const patches = new Map();
    registerLLMPatch(patches, '@anthropic-ai/sdk', 'index', 'ANTHROPIC_API_KEY', 'ANTHROPIC_BASE_URL', 'anthropic');
    registerLLMPatch(patches, 'groq-sdk', 'index', 'GROQ_API_KEY', 'GROQ_BASE_URL', 'groq');
    registerLLMPatch(patches, 'openai', 'index', 'OPENAI_API_KEY', 'OPENAI_BASE_URL', 'openai');
    return patches;
}
//# sourceMappingURL=llm.js.map