import { z } from 'zod';
import { APIClient } from '../api';
declare const _DbLogsRequestSchema: z.ZodObject<{
    database: z.ZodString;
    orgId: z.ZodString;
    region: z.ZodString;
    startDate: z.ZodOptional<z.ZodString>;
    endDate: z.ZodOptional<z.ZodString>;
    username: z.ZodOptional<z.ZodString>;
    command: z.ZodOptional<z.ZodString>;
    hasError: z.ZodOptional<z.ZodBoolean>;
    sessionId: z.ZodOptional<z.ZodString>;
    limit: z.ZodOptional<z.ZodNumber>;
}, z.core.$strip>;
export declare const DbQueryLogSchema: z.ZodObject<{
    timestamp: z.ZodString;
    username: z.ZodString;
    database: z.ZodString;
    duration: z.ZodNumber;
    txStatus: z.ZodString;
    command: z.ZodString;
    rowCount: z.ZodNumber;
    sql: z.ZodString;
    error: z.ZodOptional<z.ZodString>;
    sessionId: z.ZodOptional<z.ZodString>;
}, z.core.$strip>;
type DbLogsRequest = z.infer<typeof _DbLogsRequestSchema>;
export type DbQueryLog = z.infer<typeof DbQueryLogSchema>;
export type DbQueryLogs = DbQueryLog[];
/**
 * Get query logs for a database from the App API
 *
 * @param client APIClient configured for the App API base URL
 * @param request
 * @returns
 */
export declare function dbLogs(client: APIClient, request: DbLogsRequest): Promise<DbQueryLogs>;
export {};
//# sourceMappingURL=logs.d.ts.map