import { getServiceUrls } from '@agentuity/server';
import * as runtimeConfig from '../_config';
import { registerOtel } from './otel';
export function register(registerConfig) {
    const region = process.env.AGENTUITY_REGION ?? 'usc';
    const serviceUrls = getServiceUrls(region);
    const url = serviceUrls.otel;
    const bearerToken = process.env.AGENTUITY_OTLP_BEARER_TOKEN ?? process.env.AGENTUITY_SDK_KEY;
    const config = {
        spanProcessors: registerConfig.processors,
        name: runtimeConfig.getAppName(),
        version: runtimeConfig.getAppVersion(),
        cliVersion: runtimeConfig.getCLIVersion(),
        devmode: runtimeConfig.isDevMode(),
        orgId: runtimeConfig.getOrganizationId(),
        projectId: runtimeConfig.getProjectId(),
        deploymentId: runtimeConfig.getDeploymentId(),
        environment: runtimeConfig.getEnvironment(),
        logLevel: registerConfig.logLevel,
        jsonlBasePath: process.env.AGENTUITY_CLOUD_EXPORT_DIR,
        bearerToken,
        url,
    };
    return registerOtel(config);
}
//# sourceMappingURL=config.js.map