import { KeyValueStorageService, type Logger } from '@agentuity/core';
import type { AuthData, Config } from '../../../types';
/** KV namespace for Cadence loop state */
export declare const CADENCE_NAMESPACE = "agentuity-opencode-tasks";
/** Prefix for loop state keys */
export declare const LOOP_KEY_PREFIX = "loop:";
export interface CadenceLoop {
    loopId: string;
    parentId?: string;
    projectLabel?: string;
    sessionId?: string;
    status: 'running' | 'paused' | 'completed' | 'failed' | 'cancelled';
    iteration: number;
    maxIterations: number;
    prompt: string;
    createdAt: string;
    updatedAt: string;
    lastError?: string;
    sandbox?: {
        mode: 'off' | 'per_iteration' | 'persistent';
        sandboxId?: string;
    };
}
export interface CadenceContext {
    logger: Logger;
    config: Config | null;
    auth: AuthData;
    project?: {
        region: string;
    };
}
/**
 * Creates a KV storage service for Cadence operations.
 */
export declare function createCadenceKVAdapter(ctx: CadenceContext): Promise<KeyValueStorageService>;
/**
 * Gets the state key for a loop.
 */
export declare function getLoopStateKey(loopId: string): string;
/**
 * Parses a loop state from KV storage.
 */
export declare function parseLoopState(data: unknown): CadenceLoop | null;
//# sourceMappingURL=util.d.ts.map