import { z } from 'zod';
import { APIClient } from '../api';
declare const APIKeyCreateResponseSchema: z.ZodObject<{
    id: z.ZodString;
    value: z.ZodString;
}, z.core.$strip>;
export type APIKeyCreateResponse = z.infer<typeof APIKeyCreateResponseSchema>;
export interface APIKeyCreateRequest {
    name: string;
    expiresAt: string;
    projectId?: string | null;
    orgId?: string | null;
}
/**
 * Create a new API key
 *
 * @param client
 * @param request the API key creation request
 * @returns
 */
export declare function apikeyCreate(client: APIClient, request: APIKeyCreateRequest): Promise<APIKeyCreateResponse>;
export {};
//# sourceMappingURL=create.d.ts.map