import type { Schema } from '../base';
import { SCHEMA_KIND } from '../base';
/**
 * Schema for validating boolean values.
 *
 * @example
 * ```typescript
 * const schema = s.boolean();
 * const active = schema.parse(true); // true
 * schema.parse('true'); // throws ValidationError
 * ```
 */
export declare class BooleanSchema implements Schema<boolean, boolean> {
    readonly [SCHEMA_KIND] = "BooleanSchema";
    description?: string;
    readonly '~standard': {
        version: 1;
        vendor: string;
        validate: (value: unknown) => import("@agentuity/core").StandardSchemaV1.FailureResult | import("@agentuity/core").StandardSchemaV1.SuccessResult<boolean>;
        types: {
            input: boolean;
            output: boolean;
        };
    };
    describe(description: string): this;
    optional(): import("..").OptionalSchema<this>;
    nullable(): import("..").NullableSchema<this>;
    parse: (this: Schema<any, boolean>, value: unknown) => boolean;
    safeParse: (this: Schema<any, boolean>, value: unknown) => import("..").SafeParseResult<boolean>;
}
/**
 * Create a boolean schema.
 *
 * @example
 * ```typescript
 * const activeSchema = s.boolean().describe('Account status');
 * const active = activeSchema.parse(true);
 * ```
 */
export declare function boolean(): BooleanSchema;
//# sourceMappingURL=boolean.d.ts.map