import { type ExportResult } from '@opentelemetry/core';
import type { LogRecordExporter, ReadableLogRecord } from '@opentelemetry/sdk-logs';
/**
 * JSONL implementation of the LogRecordExporter interface
 * Writes logs to a timestamped JSONL file
 */
export declare class JSONLLogExporter implements LogRecordExporter {
    private currentFile;
    private readonly basePath;
    private readonly filePrefix;
    /**
     * Creates a new JSONL log record exporter
     * @param basePath - Directory to store the JSONL files
     */
    constructor(basePath: string);
    private ensureDirectory;
    private getOrCreateFile;
    /**
     * Exports log records to a JSONL file
     *
     * @param logs - The log records to export
     * @param resultCallback - Callback function to report the export result
     */
    export(logs: ReadableLogRecord[], resultCallback: (result: ExportResult) => void): void;
    /**
     * Shuts down the exporter
     *
     * @returns A promise that resolves when shutdown is complete
     */
    shutdown(): Promise<void>;
    /**
     * Forces a flush of any pending data
     */
    forceFlush(): Promise<void>;
}
//# sourceMappingURL=jsonl-log-exporter.d.ts.map