/**
 * Detects how the CLI was installed and is being run
 */
export type InstallationType = 'global' | 'local' | 'source';
/**
 * Determines the installation type based on how the CLI is being executed
 *
 * @returns 'global' - Installed globally via `bun add -g @agentuity/cli`
 * @returns 'local' - Running from project's node_modules (bunx or direct)
 * @returns 'source' - Running from source code (development)
 */
export declare function getInstallationType(): InstallationType;
/**
 * Check if running from a global installation
 */
export declare function isGlobalInstall(): boolean;
/**
 * Check if running from a local project installation
 */
export declare function isLocalInstall(): boolean;
/**
 * Check if running from source (development mode)
 */
export declare function isSourceInstall(): boolean;
//# sourceMappingURL=installation-type.d.ts.map