import { z } from 'zod';
import { APIClient } from '../api';
import { SessionSchema } from './list';
declare const _SessionGetRequestSchema: z.ZodObject<{
    id: z.ZodString;
}, z.core.$strip>;
declare const EvalRunSchema: z.ZodObject<{
    id: z.ZodString;
    created_at: z.ZodString;
    eval_id: z.ZodString;
    pending: z.ZodBoolean;
    success: z.ZodBoolean;
    error: z.ZodNullable<z.ZodString>;
    result: z.ZodNullable<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
}, z.core.$strip>;
export interface SpanNode {
    id: string;
    duration: number;
    operation: string;
    attributes: Record<string, unknown>;
    children?: SpanNode[];
    error?: string;
}
declare const RouteInfoSchema: z.ZodNullable<z.ZodObject<{
    id: z.ZodString;
    method: z.ZodString;
    path: z.ZodString;
}, z.core.$strip>>;
declare const AgentInfoSchema: z.ZodObject<{
    name: z.ZodString;
    identifier: z.ZodString;
}, z.core.$strip>;
type SessionGetRequest = z.infer<typeof _SessionGetRequestSchema>;
export type Session = z.infer<typeof SessionSchema>;
/**
 * Get a single session by id
 *
 * @param client
 * @param request
 * @returns
 */
export type EvalRun = z.infer<typeof EvalRunSchema>;
export type RouteInfo = z.infer<typeof RouteInfoSchema>;
export type AgentInfo = z.infer<typeof AgentInfoSchema>;
export type EnrichedSession = {
    session: Session;
    agents: AgentInfo[];
    evalRuns: EvalRun[];
    timeline: SpanNode | null;
    route: RouteInfo;
};
export declare function sessionGet(client: APIClient, request: SessionGetRequest): Promise<EnrichedSession>;
export {};
//# sourceMappingURL=get.d.ts.map