import { z } from 'zod';
import { APIClient } from '../api';
declare const ResourceListResponse: z.ZodObject<{
    s3: z.ZodArray<z.ZodObject<{
        bucket_name: z.ZodString;
        access_key: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        secret_key: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        region: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        endpoint: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        cname: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        env: z.ZodRecord<z.ZodString, z.ZodString>;
    }, z.core.$strip>>;
    db: z.ZodArray<z.ZodObject<{
        name: z.ZodString;
        username: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        password: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        url: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        env: z.ZodRecord<z.ZodString, z.ZodString>;
    }, z.core.$strip>>;
    redis: z.ZodOptional<z.ZodObject<{
        url: z.ZodString;
    }, z.core.$strip>>;
}, z.core.$strip>;
declare const ResourceListResponseSchema: z.ZodDiscriminatedUnion<[z.ZodObject<{
    success: z.ZodLiteral<false>;
    message: z.ZodString;
}, z.core.$strip>, z.ZodObject<{
    success: z.ZodLiteral<true>;
    data: z.ZodObject<{
        s3: z.ZodArray<z.ZodObject<{
            bucket_name: z.ZodString;
            access_key: z.ZodOptional<z.ZodNullable<z.ZodString>>;
            secret_key: z.ZodOptional<z.ZodNullable<z.ZodString>>;
            region: z.ZodOptional<z.ZodNullable<z.ZodString>>;
            endpoint: z.ZodOptional<z.ZodNullable<z.ZodString>>;
            cname: z.ZodOptional<z.ZodNullable<z.ZodString>>;
            env: z.ZodRecord<z.ZodString, z.ZodString>;
        }, z.core.$strip>>;
        db: z.ZodArray<z.ZodObject<{
            name: z.ZodString;
            username: z.ZodOptional<z.ZodNullable<z.ZodString>>;
            password: z.ZodOptional<z.ZodNullable<z.ZodString>>;
            url: z.ZodOptional<z.ZodNullable<z.ZodString>>;
            env: z.ZodRecord<z.ZodString, z.ZodString>;
        }, z.core.$strip>>;
        redis: z.ZodOptional<z.ZodObject<{
            url: z.ZodString;
        }, z.core.$strip>>;
    }, z.core.$strip>;
}, z.core.$strip>], "success">;
export type ResourceListResponse = z.infer<typeof ResourceListResponseSchema>;
export type ResourceList = z.infer<typeof ResourceListResponse>;
/**
 * List all resources for a given organization and region
 *
 * @param client
 * @param orgId
 * @param region
 * @returns
 */
export declare function listResources(client: APIClient, orgId: string, region: string): Promise<ResourceList>;
export {};
//# sourceMappingURL=resources.d.ts.map